namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	/// <Developers>
	/// 	<Developer>Margaret Jablonski</Developer>
	/// </Developers>
	/// <SiteName>Hines OIFO</SiteName>
	/// <CreationDate>07/24/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// DatabaseConstants
	/// </summary>

	#endregion

	public class DatabaseConstants
	{
		/// <summary>
		/// This class will hold names for all the artificial columns created 
		/// in the stored procedures using 'AS' followed by the column name syntax.
		/// Those columns will not have corresponding names in AutoGenVbecsTables class. 
		/// </summary>
		public class ArtificialColumnNames
		{
			/// <summary>
			/// List of all custom column names that don't exist on any table
			/// </summary>
			public const string
				A1Cells = "A1Cells",
				A1CellsGuid = "A1CellsGuid",
				A1CellsRowVersion = "A1CellsRowVersion",
				A1CellsSave = "A1CellsSave",
				AboInterp = "AboInterp",
				AboComment = "AboComment",
				ABO = "ABO",
				AboInterpGuid = "AboInterpGuid",
				AboInterpRowVersion = "AboInterpRowVersion",
				AboInterpSave = "AboInterpSave",
                ABORh = "ABORh",
				ABORhDate = "ABORhDate",
				AboRhDiscrepancyException = "AboRhDiscrepancyException",
				ABORhDivision = "ABORhDivision",
				AboRhInconclusiveException = "AboRhInconclusiveException",
				ABOSortColumn = "ABOSortColumn",
				ABSComment = "ABSComment",
				ABSInterp = "ABSInterp",
				ABSInterpGuid = "ABSInterpGuid",
				ABSInterpRowVersion = "ABSInterpRowVersion",
				ABSInterpSave = "ABSInterpSave",
				ACTIVE = "ACTIVE", 
				AddressMirrorRecordCount = "AddressMirrorRecordCount",
				AddressRowVersion = "addressrowversion",
				AdditionalInformation = "AdditionalInformation",
				AHG = "AHG",
				AHGComment = "AHGComment",
				AHGGuid = "AHGGuid",
				AHGInterp = "AHGInterp",
				AHGInterpGuid = "AHGInterpGuid",
				AHGInterpRowVersion = "AHGInterpRowVersion",
				AHGInterpSave = "AHGInterpSave",
				AHGRowVersion = "AHGRowVersion",
				AHGSave = "AHGSave",
				AntiABGuid = "AntiABGuid",
				AntiABRowVersion = "AntiABRowVersion",
				AntiABSave = "AntiABSave",
				AntiAGuid = "AntiAGuid",
				AntiARowVersion = "AntiARowVersion",
				AntiASave = "AntiASave",
				AntiBGuid = "AntiBGuid",
				AntiBRowVersion = "AntiBRowVersion",
				AntiBSave = "AntiBSave",
				AntiDCC = "AntiDCC",
				AntiDGuid = "AntiDGuid",
				AntiDReagentGuid = "AntiDReagentGuid",
				AntiDRowVersion = "AntiDRowVersion",
				AntiDSave = "AntiDSave",
				AntigenPositiveUnitException = "AntigenPositiveUnitException",
				AntigenTyping = "AntigenTyping",
				AlternateCollectionFacility = "AlternateCollectionFacility", 
				AntiseraOrderedTestRowVersion = "AntiseraOrderedTestRowVersion",
				AntiseraUnitTestRowVersion = "AntiseraUnitTestRowVersion",
				AssignedPatientCount = "AssignedPatientCount",
				AssignedPatients = "AssignedPatients",
				AuditDate = "AuditDate",
				AuditIdentifier = "AuditIdentifier",
				AuditType = "AuditType",
				AuditUser = "AuditUser",
				AutoInstrument = "AutoInstrument",
				BagCannedCommentGuid = "BagCannedCommentGuid",
				BagCommentText = "BagCommentText",
				BarcodeType = "BarcodeType",
				BCells = "BCells",
				BCellsGuid = "BCellsGuid",
				BCellsRowVersion = "BCellsRowVersion",
				BCellsSave = "BCellsSave",
				Biohazardous = "Biohazardous",
				BloodType = "BloodType",
				BloodTypeRhFactor = "BloodTypeRhFactor",
				BloodUnitAntigens = "BloodUnitAntigens",
				BloodUnitTestId = "BloodUnitTestId",
				BR207 = "BR207",
				BR217 = "BR217",
				BR221 = "BR221",
				BTRFRemarks = "BTRFRemarks",
				C3d = "C3d",
				C3dComment = "C3dComment",
				C3dGuid = "C3dGuid",
				C3dInterp = "C3dInterp",
				C3dInterpGuid = "C3dInterpGuid",
				C3dInterpRowVersion = "C3dInterpRowVersion",
				C3dInterpSave = "C3dInterpSave",
				C3dRowVersion = "C3dRowVersion",
				C3dSave = "C3dSave",
				C37 = "37",
				C37Guid = "37Guid",
				C37RowVersion = "37RowVersion",
				C37Save = "37Save",
				Category = "Category",
				CC = "CC",
				CCGuid = "CCGuid",
				CCRowVersion = "CCRowVersion",
				CCSave = "CCSave",
				CcResults = "CcResults",
				CheckCannedCommentGuid = "CheckCannedCommentGuid",
				CheckCommentText = "CheckCommentText",
				ChangedFieldName = "ChangedFieldName",
				City = "City",
				CityStateZip = "CityStateZip",
				CMV = "CMV", 
				CMVNegative = "CMVNegative",
				CodeAndShortName = "CodeAndShortName",
				CollectionFacility = "CollectionFacility", 
				Comment = "Comment",
				CompletedBy = "CompletedBy",
				CompletedDateTime = "CompletedDateTime",
				ComponentClassSortColumn = "ComponentClassSortColumn",
				ComponentTestGuid = "ComponentTestGuid",
				ComponentTestName = "ComponentTestName",
				ComponentTestComment = "ComponentTestComment",
                ConflictContext = "ConflictContext",
				Control = "Control",
				ControlComment = "ControlComment",
				ControlD = "ControlD",
				ControlDCC = "ControlDCC",
				ControlDGuid = "ControlDGuid",
				ControlDRowVersion = "ControlDRowVersion",
				ControlDSave = "ControlDSave",
				ControlInterp = "ControlInterp",
				ControlInterpGuid = "ControlInterpGuid",
				ControlInterpSave = "ControlInterpSave",
				ControlReagentGuid = "ControlReagentGuid",
				ConversionBloodTypeCode = "ConversionBloodTypeCode",
				ConversionRhFactorCode = "ConversionRhFactorCode",
				Cost = "Cost",
				CPTCode_Text = "CPTCode_Text",
				CreationDate = "CreationDate",
				CreationUser = "CreationUser",
				Crossmatched = "Crossmatched",
				CurrentMaintenanceDate = "CurrentMaintenanceDate",
				//CR 3195
				CurrentStatusLastUpdateDate = "CurrentStatusLastUpdateDate",
				CustomReportFilterStatement = "CustomReportFilterStatement",
				D37 = "D37",
				D37Guid = "D37Guid",
				D37RowVersion = "D37RowVersion",
				D37Save = "D37Save",
				DAHG = "DAHG",
				DAHGGuid = "DAHGGuid",
				DAHGRowVersion = "DAHGRowVersion",
				DAHGSave = "DAHGSave",
				DateEntered = "DateEntered",
				Dc37 = "Dc37",
				Dc37Guid = "Dc37Guid",
				Dc37Save = "Dc37Save",
				Dc37RowVersion = "Dc37RowVersion",
				DcAHG = "DcAHG",
				DcAHGGuid = "DcAHGGuid",
				DcAHGRowVersion = "DcAHGRowVersion",
				DcAHGSave = "DcAHGSave",
				DCC = "DCC",
				DCCGuid = "DCCGuid",
				DCCRowVersion = "DCCRowVersion",
				DCCSave = "DCCSave",
				DcCC = "DcCC",
				DcCCGuid = "DcCCGuid",
				DcCCRowVersion = "DcCCRowVersion",
				DcCCSave = "DcCCSave",
				DControlReagentGuid = "DControlReagentGuid",
				DetailedReport = "DetailedReport",
				DetailedReportRowCount = "DetailedReportRowCount",
				DetailReport = "DetailReport",
				DirectedPatientFirstName = "DirectedPatientFirstName",
				DirectedPatientLastName = "DirectedPatientLastName",
				DirectedPatientMiddleName = "DirectedPatientMiddleName",
				DirectedType = "DirectedType",
				DiscardType = "DiscardType",
				DiscardedUnitsVisibleIndicator = "DiscardedUnitsVisibleIndicator",
				Discrepancy = "Discrepancy",
				DiscrepantTypingException = "DiscrepantTypingException",
				DivisionsWithActiveOrders = "DivisionsWithActiveOrders", // CR 3164
				DonationTypes = "DonationTypes",
				EmergencyIssue= "EmergencyIssue",
				EmergencyIssueExceptions = "EmergencyIssueExceptions",
				EndDate = "EndDate",
				EnvironmentType = "EnvironmentType",
				EquipmentMirrorRecordCount = "EquipmentMirrorRecordCount",
				ExceptionUserName = "ExceptionUserName",
				ExpirationDate = "Expiration Date",	// Has a space in it
				ExpiredOverrideComment = "ExpiredOverrideComment",
				Fax = "Fax",
				FinalizeCannedCommentGuid = "FinalizeCannedCommentGuid",
				FinalizeCommentText = "FinalizeCommentText",
				FinalizedBy = "FinalizedBy",
				FinalizedDateTime = "FinalizedDateTime",
				FilterStatement = "FilterStatement",
				FromDisplayVistaPatientId = "FromDisplayVistaPatientId",
				FromPatientMiddleName = "FromPatientMiddleName",
				FullProductCode = "FullProductCode",
				GroupBy = "GroupBy",
				GroupByPatient = "GroupByPatient",
				GroupByPatientTest = "GroupByPatientTest",
				Guid = "Guid",
				IatResults = "IatResults",
				IgG = "IgG",
				IgGComment = "IgGComment",
				IgGGuid = "IgGGuid",
				IgGInterp = "IgGInterp",
				IgGInterpGuid = "IgGInterpGuid",
				IgGInterpRowVersion = "IgGInterpRowVersion",
				IgGInterpSave = "IgGInterpSave",
				IgGRowVersion = "IgGRowVersion",
				IgGSave = "IgGSave",
				ImplicatedBagReturned = "ImplicatedBagReturned",
				ImplicatedClericalChecks = "ImplicatedClericalChecks",
				ImplicatedComment = "ImplicatedComment",
				ImplicatedDateEntered = "ImplicatedDateEntered",
				ImplicatedEnteredBy = "ImplicatedEnteredBy",
				ImplicatedHemolysis = "ImplicatedHemolysis",
				ImplicatedProductNames = "ImplicatedProductNames",
				ImplicatedUnitIds = "ImplicatedUnitIds",
				InactivatedUnitsVisibleIndicator = "InactivatedUnitsVisibleIndicator",
				InactivationUser = "InactivationUser",
				IncludeAntigenTypingReport = "IncludeAntigenTypingReport",
				IncludeDetailedReport = "IncludeDetailedReport",
				IncludeExceptionReport = "IncludeExceptionReport",
				IncludeExceptionSection = "IncludeExceptionSection",
				IncludePatientDemographics = "IncludePatientDemographics",
				IncludePatientExceptionReports = "IncludePatientExceptionReports",
				IncludePatientSpecimens = "IncludePatientSpecimens",
				IncludePatientTesting = "IncludePatientTesting",
				IncludePatientTransfusionReactions = "IncludePatientTransfusionReactions",
				IncludePatientTransfusionRequirements = "IncludePatientTransfusionRequirements",
				IncludePatientTransfusions = "IncludePatientTransfusions",
				IncludePatientUnitAssignments = "IncludePatientUnitAssignments",
				IncludePhysicianSummary = "IncludePhysicianSummary",
				IncludeRackTesting = "IncludeRackTesting",
				IncludeReagentTesting = "IncludeReagentTesting",
				IncludeRestrictedPatientReport = "IncludeRestrictedPatientReport",
				IncludeSpecialInstructionSection = "IncludeSpecialInstructionSection",
				IncludeSpecialtySummary = "IncludeSpecialtySummary",
				IncludeUnitTesting = "IncludeUnitTesting",
				IncomingShipmentsVisibleIndicator = "IncomingShipmentsVisibleIndicator",
				Indicator = "Indicator",
				IndicatorMessage = "IndicatorMessage",
				InitialABO = "InitialABO",
				InitialRh = "InitialRh",
				Interp = "Interp",
				InterpGuid = "InterpGuid",
				InterpRowVersion = "InterpRowVersion",
				InterpSave = "InterpSave",
				InvalidatedBy = "InvalidatedBy",
				InvalidateUserName = "InvalidateUserName",
				IsAntigenTypedInventoryReport = "IsAntigenTypedInventoryReport",
				IsComponentOrder = "IsComponentOrder",
				IsCumulativeReport = "IsCumulativeReport", // CR 3187
				IsCustomReport = "IsCustomReport",
				IsDailyInventoryAllReport = "IsDailyInventoryAllReport",
				IsDailyInventoryAvailableReport = "IsDailyInventoryAvailableReport",
				IsFinalDispositionReport = "IsFinalDispositionReport",
				IsIndividualPatientReport = "IsIndividualPatientReport",
				IsMultiDivisional = "IsMultiDivisional",
				IsNoDispositionReport = "IsNoDispositionReport",
				IsOnlyXMatch = "IsOnlyXMatch",
				IsOrderedComponent = "IsOrderedComponent",
				IsResults = "IsResults",
				IsSingleOrderReport = "IsSingleOrderReport",
				IS = "IS",
				ISGuid = "ISGuid",
				ISRowVersion = "ISRowVersion",
				ISSave = "ISSave",
				IssuedToLocationReport = "IssuedToLocationReport",
				IssuingPhysicianReport = "IssuingPhysicianReport",
				LockConflictIndicator = "LockConflictIndicator",
				LoginTechId = "LoginTechId",
				Lot_Number = "Lot_Number",
				LotNumberSave = "LotNumberSave",
				MaintenanceRecordCount = "MaintenanceRecordCount",
				Manufacturer = "Manufacturer",
				MedicalDirectorApprovalException = "MedicalDirectorApprovalException",
				MergeFromPatientDisplayName = "MergeFromPatientDisplayName",
				MergeFromPatientFirstName = "MergeFromPatientFirstName",
				MergeFromPatientLastName = "MergeFromPatientLastName",
				MergeFromPatientMiddleName = "MergeFromPatientMiddleName",
				MergeFromRowVersion = "MergeFromRowVersion",
				MergeToPatientDisplayName = "MergeToPatientDisplayName",
				MergeToPatientFirstName = "MergeToPatientFirstName",
				MergeToPatientLastName = "MergeToPatientLastName",
				MergeToPatientMiddleName = "MergeToPatientMiddleName",
				MergeToRowVersion = "MergeToRowVersion",
				MirrorDate = "MirrorDate",
				MirrorId = "MirrorId",
				NewValue = "NewValue",
				NoDataIndicator = "NoDataIndicator",
				NonStandardTestException = "NonStandardTestException",
				NonStandardTestExceptionIndicator = "NonStandardTestExceptionIndicator",
				NumberVialsInStock = "NumberVialsInStock",
				OffSiteABIDsVisibleIndicator = "OffSiteABIDsVisibleIndicator",
				OldValue = "OldValue",
				OrderedDate = "OrderedDate",
				OrderedItem = "OrderedItem",
				OrderedTestRowVersion = "OrderedTestRowVersion",
				OrderedUnitRowVersion = "OrderedUnitRowVersion",
				OrderedTestDivisionCode = "OrderedTestDivisionCode",
				OrderExpirationDate = "OrderExpirationDate",
				OrderingLocation = "OrderingLocation",
				OrderingMD = "OrderingMD",
				OrderingProviderName = "OrderingProviderName",
				OrderUrgency = "OrderUrgency",
				OutgoingShipmentsVisibleIndicator = "OutgoingShipmentsVisibleIndicator",
				OverrideComment = "OverrideComment",
				PartiallyCompleted = "PartiallyCompleted",
				PatientDisplayName = "PatientDisplayName",
				PatientOrderExpired = "PatientOrderExpired",
				PatientABO = "PatientABO",	// CR 2941
				PatientReportId = "PatientReportId",
				PatientReportName = "PatientReportName",
				PatientRh = "PatientRh",	// CR 2941
				PatientSpecimenCommentText = "PatientSpecimenCommentText",
				PatientSymptomDateEntered = "PatientSymptomDateEntered",
				PatientSymptomEnteredBy = "PatientSymptomEnteredBy",
				PatientSymptomName = "PatientSymptomName",
				PatientTestingRowCount = "PatientTestingRowCount",
				PatientTransfusionRequirement = "PatientTransfusionRequirement",	// CR 2941
				PatientTRANString = "PatientTRANString",
				PendingPatientMergesCount = "PendingPatientMergesCount",
				PendingTransferIndicator = "PendingTransferIndicator",
				PGuid = "PGuid",
				PhaseChangedException = "PhaseChangedException",
				PhaseOverrideComment = "PhaseOverrideComment",
				Phlebotomist = "Phlebotomist",
				Phone = "Phone",
				PhysicianSummaryRowCount = "PhysicianSummaryRowCount",
				PrintFormsComment = "PrintFormsComment",
				ProductActiveIndicator = "ProductActiveIndicator",
				ProviderDisplayName = "ProviderDisplayName",
				PooledUnitsCount = "PooledUnitsCount",
				PostCCCannedCommentGuid = "PostCCCannedCommentGuid",
				PostCCCommentText = "PostCCCommentText",
				PostHemolysisInspectionCode = "PostHemolysisInspectionCode",
				PostHemolysisInspectionText = "PostHemolysisInspectionText",
				PostNACannedCommentGuid = "PostNACannedCommentGuid",
				PostNACommentText = "PostNACommentText",
				PostSpecimenGuid = "PostSpecimenGuid",
				PostSpecimenUid = "PostSpecimenUid",
				PreCCCannedCommentGuid = "PreCCCannedCommentGuid",
				PreCCCommentText = "PreCCCommentText",
				PreHemolysisInspectionCode = "PreHemolysisInspectionCode",
				PreHemolysisInspectionText = "PreHemolysisInspectionText",
				Preliminary = "Preliminary",
				PreliminaryReportIndicator = "PreliminaryReportIndicator",
				PreNACannedCommentGuid = "PreNACannedCommentGuid",
				PreNACommentText = "PreNACommentText",
				PreSpecimenGuid = "PreSpecimenGuid",
				PreSpecimenUid = "PreSpecimenUid",
				PrintDate = "PrintDate",
				PrintedBy = "PrintedBy",
				PrinterName = "PrinterName",
				PrintForms = "PrintForms",
				Procedure = "Procedure",
				Process = "Process",
				ProcessedBy = "ProcessedBy",
				ProcessTechId = "ProcessTechId",
				QcDate = "QcDate",
				RackLotRowVersion = "RackLotRowVersion",
				RackTestingRowCount = "RackTestingRowCount",
				RackTestRowVersion = "RackTestRowVersion",
				ReagentTestingRowCount = "ReagentTestingRowCount",
				ReagentType = "ReagentType",
				ReagentExpiredException = "ReagentExpiredException",
				RecordCount = "RecordCount",
				ReflexTestsExist = "ReflexTestsExist",
				RemainingLockTime = "RemainingLockTime",
				RepeatAboRhDiscrepancyException = "RepeatAboRhDiscrepancyException",
				ReportCriteria = "ReportCriteria",
				ReportName = "ReportName",
				ReportParameters = "ReportParameters",
				ReportTestName = "ReportTestName",
				RequestedProcedure = "RequestedProcedure",
				RequestSortColumn = "RequestSortColumn",
				RequirementText = "RequirementText",
				Rh = "Rh",
				RhComment = "RhComment",
				RhInterp = "RhInterp",
				RhInterpGuid = "RhInterpGuid",
				RhInterpRowVersion = "RhInterpRowVersion",
				RhInterpSave = "RhInterpSave",
				RTRowVersion = "RTRowVersion",
				RhSortColumn = "RhSortColumn",
				RT = "RT",
				RTGuid = "RTGuid",
				RTSave = "RTSave",
				SCNegative = "SCNegative",
				ScreeningCells = "ScreeningCells",
				SenderAddressLine1 = "SenderAddressLine1",
				SenderAddressLine2 = "SenderAddressLine2",
				SenderCityStateZip = "SenderCityStateZip",
				SenderFacilityName = "SenderFacilityName",
				SetVialId = "SetVialId",
				ShipmentFacility = "ShipmentFacility", 
				SickleCellInterp = "Sickle Cell Interp",
				SortByDate = "SortByDate",
				SortByTreatingSpecialty = "SortByTreatingSpecialty",
				SortDate = "SortDate",
				Source = "Source",
				SpecialInstructionSectionRecordCount = "SpecialInstructionSectionRecordCount",
				SpecialtySummaryRowCount = "SpecialtySummaryRowCount",
				SpecimenHistoryExists = "SpecimenHistoryExists",
				SpecimenStatus = "SpecimenStatus",
				SpecimenTestRowVersion = "SpecimenTestRowVersion",
				StartDate = "StartDate",
				State = "State",
				SuccessIndicator = "SuccessIndicator",
				SystemABO = "SystemABO",
				SystemAHGInterp = "SystemAHGInterp",
				SystemC3dInterp = "SystemC3dInterp",
				SystemControlInterp = "SystemControlInterp",
				SystemIgGInterp = "SystemIgGInterp",
				SystemRh = "SystemRh",
				TableName = "TableName",
				TechId = "TechId",
				TemplateText = "TemplateText",
				TestedBy = "TestedBy",
				TestGuid = "TestGuid",
				TestOrderUniqueId = "TestOrderUniqueId",
				TestUniqueId = "TestUniqueId",
				Total = "Total",
				TestDateEntered = "TestDateEntered",
				TestDivision = "TestDivision",
				TestEnteredBy = "TestEnteredBy",
				TestingMethod = "TestingMethod",
				TestingWorklistReportType = "TestingWorklistReportType",
				Tests = "Tests",
				TestType = "TestType",
				TestUnitId = "TestUnitId",
				ThisDivision = "ThisDivision",
				ThresholdType = "ThresholdType",
				Transfused = "Transfused",
				TransfusionPooledUnitsCount = "TransfusionPooledUnitsCount",
				TransfusionistIds = "TransfusionistIds",
				TransfusionEndDate = "TransfusionEndDate",
				TransfusionReactionSectionRecordCount = "TransfusionReactionSectionRecordCount",
				TransfusionRequirementSectionRecordCount = "TransfusionRequirementSectionRecordCount",
				TransfusionStartDate = "TransfusionStartDate",
				TransfusionType = "TransfusionType", 
				TreatingSpecialityReport = "TreatingSpecialityReport",
				ToDisplayVistaPatientId = "ToDisplayVistaPatientId",
				ToPatientMiddleName = "ToPatientMiddleName",
				UnitAboRh = "UnitAboRh",	// CR 2941
				UnitExpiration = "UnitExpiration",
				UnitFinanceRowVersion = "unitfinancerowversion",
				UnitIdentification = "UnitIdentification",
				UnitMediaRowVersion = "unitmediarowversion",
				UnitModifications = "UnitModifications",
				UnitModificationsVisibleIndicator = "UnitModificationsVisibleIndicator",
				UnitProductCode = "UnitProductCode",	// CR 2941
				UnitRowVersion = "unitrowversion",
				UnitStatus = "UnitStatus",
				UnitStatusRowVersion = "unitstatusrowversion",
				UnitStatusSortColumn = "UnitStatusSortColumn",
				UnitTestingRowCount = "UnitTestingRowCount",
				UrgencySortColumn = "UrgencySortColumn",
				VialId = "VialId",
				VialIdSave = "VialIdSave",
				WantedDate = "WantedDate",
				WeakDComment = "WeakDComment",
				WeakDInterp = "WeakDInterp",
				WorklistDate = "WorklistDate",
				XMComment = "XMComment",
				XMInterp = "XMInterp",
				XMInterpGuid = "XMInterpGuid",
				XMInterpRowVersion = "XMInterpRowVersion",
				XMInterpSave = "XMInterpSave",
				UserDivisionRoleRowVersion = "UserDivisionRoleRowVersion",
				UserDivisionRoleRecordStatusCode = "UserDivisionRoleRecordStatusCode",
				Zip = "Zip";
		}

		/// <summary>
		/// This class will hold names for the tables created in the external 
		/// VistALink remote procedures and packaged in data sets.
		/// </summary>
		public class VistALinkTableNames
		{
			/// <summary>
			/// List of table names for the VistALink.
			/// </summary>
			public const string
				BloodBankUser = "BloodBankUser",
				Divisions = "Divisions";
		}

		/// <summary>
		/// This class will hold names for all the artificial columns created 
		/// in the external VistALink remote procedures.
		/// Those columns will not have corresponding names in AutoGenVbecsTables class. 
		/// </summary>
		public class VistALinkColumnNames
		{
			/// <summary>
			/// List of all custom column names for VistALink
			/// </summary>
			public const string
				CollectionDateTime = "CollectionDateTime",
				Error = "Error",
				IEN = "IEN",
				LabTestId = "LabTestId",
				Name = "Name",
				Specimen = "Specimen",
				LabOrderNumber = "LabOrderNumber",
				LocationName = "LocationName",
				LocationType = "LocationType",
				LocationIen = "LocationIen",
				ProviderName = "ProviderName",
				ProviderIEN = "ProviderIEN",
				SpecimenAccessionNumber = "SpecimenAccessionNumber",
				VistaPatientId = "VistaPatientId",
				VistaLaboratoryTestName = "VistaLaboratoryTestName",
				TestPrintName = "TestPrintName",
				TestResult = "TestResult",
				ResultDateTime = "ResultDateTime",
				AccessionAreaName = "AccessionAreaName",
				AccessionAreaId = "AccessionAreaId",
				VistaUserName = "UserName",
				VistaUserDuz = "UserDUZ",
				VistaUserInitials = "UserInitials",
				DivisionCode = "divisionCode";
		}

		/// <summary>
		/// Names of artificial tables (query subsets) needed by inappropriate transfusion request report. 
		/// </summary>
		public class InappropriateTransfusionRequestReportDataUnits
		{
			/// <summary>
			/// Names for DataTables and DataSets used in inappropriate transfusion request report. 
			/// </summary>
			public const string
				ReportDataSetName = "InappropriateTransfusionRequests",
				InappropriateSurgicalRequestsTableName = "InappropriateSurgicalRequests",
				InappropriateNonSurgicalRequestsTableName = "InappropriateNonSurgicalRequests",
				DivisionMsbosRecommendationsTableName = "DivisionMsbosRecommendations",
				DivisionTestingThresholdsTableName = "DivisionTestingThresholds", 
				PatientTestResultsTableName = "TestResults";
		}

		/// <summary>
		/// This class will hold names for all the artificial columns 
		/// needed for Administrative Data Report Schema
		/// Those columns will not have corresponding names in AutoGenVbecsTables class. 
		/// </summary>
		public class AdminReportColumnNames
		{
			/// <summary>
			/// List of all custom column names for Administrative Data Report
			/// </summary>
			public const string
				DivisionCode = "DivisionCode",
				ComponentClassName = "ComponentClassName",
				SubdivisionName = "SubDivisionName",
				ReceivedAllogeneic = "ReceivedAllogeneic",
				ReceivedDirected = "ReceivedDirected",
				ReceivedAutologous = "ReceivedAutologous",
				ModifiedAllogeneic  = "ModifiedAllogeneic",
				ModifiedAllogeneicPooledUnits  = "ModifiedAllogeneicPooledUnits",
				ModifiedDirected = "ModifiedDirected",
				ModifiedDirectedPooledUnits = "ModifiedDirectedPooledUnits",
                ModifiedAutologous = "ModifiedAutologous",
				ModifiedAutologousPooledUnits = "ModifiedAutologousPooledUnits",
				TransfusedAllogeneic  = "TransfusedAllogeneic",
				TransfusedDirected = "TransfusedDirected",
				TransfusedAutologous = "TransfusedAutologous",
				ShippedAllogeneic  = "ShippedAllogeneic",
				ShippedDirected = "ShippedDirected",
				ShippedAutologous = "ShippedAutologous",
				OutdatedAllogeneic  = "OutdatedAllogeneic",
				OutdatedDirected = "OutdatedDirected",
				OutdatedAutologous = "OutdatedAutologous",
				DiscardedAllogeneic  = "DiscardedAllogeneic",
				DiscardedDirected = "DiscardedDirected",
				DiscardedAutologous = "DiscardedAutologous";
				
		}

		/// <summary>
		/// This class will hold names for all subdivision names
		/// needed for Administrative Data Report 
		/// </summary>
		public class AdminReportSubdivision
		{
			/// <summary>
			/// List of subdivision names for Administrative Data Report
			/// </summary>
			public const string
				CMVNegative = "CMV negative",
				Deglycerolized = "Deglycerolized",
				Frozen = "Frozen",
				FrozenRejuvenated = "Frozen/Rejuvenated",
				Irradiated = "Irradiated",
				IrradiateCells = "Irradiate Cells",
				Leukoreduced = "Leukoreduced",
				Pooled = "Pooled",
				Rejuvenated = "Rejuvenated", 
				SCNegative = "SC negative",
				SplitDivided = "Split/Divided",
				Thawed = "Thawed",
				ThawedPooled = "Thawed/Pooled",
				VolumeReduce = "Volume reduce",
				WashPlatelets = "Wash Platelets",
				WashRBC = "Wash RBC";
		}

		/// <summary>
		/// This class will hold names for all section names (the same as Component Class Name)
		/// needed for Administrative Data Report 
		/// </summary>
		public class AdminReportSection
		{
			/// <summary>
			/// List of subdivision names for Administrative Data Report
			/// </summary>
			public const string
				RedBloodCells = "Red Blood Cells",
				WholeBlood = "Whole Blood",
				FreshFrozenPlasma = "Fresh Frozen Plasma",
				Platelets = "Platelets",
				Cryoprecipitate = "Cryoprecipitate",
				Other = "Other";
		}

		/// <summary>
		/// Names of artificial tables needed by 
		/// the blood unit history report
		/// </summary>
		public class BloodUnitReportTables
		{
			/// <summary>
			/// List of table names used by the blood unit history report
			/// </summary>
			public const string
				AntigenTypingReport = "AntigenTypingReport",
				BloodUnitHistorySummary = "BloodUnitHistorySummary",
				BloodUnitTestingReport = "BloodUnitTestingReport",
				CrossmatchTestingReport = "CrossmatchTestingReport",
				DirectedPatientReport = "DirectedPatientReport",
				FinanceReport = "FinanceReport",
				IncomingShipmentReport = "IncomingShipmentReport",
				IssueReport = "IssueReport",
				ModificationEquipmentAndSupplies = "ModificationEquipmentAndSupplies",
				ModificationReport = "ModificationReport",
				OriginalUnitsFromModification = "OriginalUnitsFromModification",
				TargetUnitsFromModification = "TargetUnitsFromModification",
				OutgoingShipmentReport = "OutgoingShipmentReport",
				PatientAssociationReport = "PatientAssociationReport",
				StatusReport = "StatusReport",
				TransfusionReport = "TransfusionReport";
		}

		/// <summary>
		/// Names of artificial column names needed by 
		/// the summary section of the blood unit history report
		/// </summary>
		public class BloodUnitReportSummary
		{
			/// <summary>
			/// List of artificial column names needed by 
			/// the summary section of the blood unit history report
			/// </summary>
			public const string
				AnitgenTypingReportRecordCount = "AnitgenTypingReportRecordCount", 
				BloodUnitTestingReportRecordCount = "BloodUnitTestingReportRecordCount", 
				CrossmatchTestingReportRecordCount = "CrossmatchTestingReportRecordCount", 
				DirectedPatientReportRecordCount = "DirectedPatientReportRecordCount", 
				FinanceReportRecordCount = "FinanceReportRecordCount", 
				IncludeAnitgenTypingReport = "IncludeAnitgenTypingReport", 
				IncludeBloodUnitTestingReport = "IncludeBloodUnitTestingReport", 
				IncludeCrossmatchTestingReport = "IncludeCrossmatchTestingReport", 
				IncludeDirectedPatientReport = "IncludeDirectedPatientReport", 
				IncludeFinanceReport = "IncludeFinanceReport", 
				IncludeIncomingShipmentReport = "IncludeIncomingShipmentReport", 
				IncludeIssueReport = "IncludeIssueReport", 
				IncludeModificationReport = "IncludeModificationReport", 
				IncludeOutgoingShipmentReport = "IncludeOutgoingShipmentReport", 
				IncludePatientAssociationReport = "IncludePatientAssociationReport", 
				IncludeStatusReport = "IncludeStatusReport", 
				IncludeTransfusionReport = "IncludeTransfusionReport",
				IncomingShipmentReportRecordCount = "IncomingShipmentReportRecordCount", 
				IssueReportRecordCount = "IssueReportRecordCount", 
				ModificationReportRecordCount = "ModificationReportRecordCount", 
				OutgoingShipmentReportRecordCount = "OutgoingShipmentReportRecordCount", 
				PatientAssociationReportRecordCount = "PatientAssociationReportRecordCount", 
				StatusReportRecordCount = "StatusReportRecordCount", 
				TransfusionReportRecordCount = "TransfusionReportRecordCount";
		}

		/// <summary>
		/// Names of unique indices enforcing appropriate BRs for the MUC03.
		/// </summary>
		public class VbecsUserUniqueConstraints
		{
			/// <summary>
			/// List of constraints needed to enforce uniqueness of users in MUC03.
			/// </summary>
			public const string 
				PkVbecsUserId = "PK_VbecsUser",
				UcVbecsUserUserDuz = "UCK_VbecsUser_UserDuz",
				UcVbecsUserUserInitials = "UCK_VbecsUser_UserInitials",
				UcVbecsUserVistaUserName = "UCK_VbecsUser_VistaUserName";
		}

		/// <summary>
		/// List of table names needed by VistACache
		/// </summary>
		public class WorkloadTableNames
		{
			/// <summary>
			/// List of table names needed by VistACache
			/// </summary>
			public const string
				Code = "Code", 
				CPTCode = "CPTCode";
		}
	}
}
